{* -*- Tab-Width: 4; -*-                                                 *}
{*                                                                       *}
{*                                                                       *}
{*                      RESTRICTED RIGHTS LEGEND                         *}
{*                                                                       *}
{* Use, duplication, or disclosure by the Government is subject to       *}
{* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  *}
{* Technical Data and Computer Software clause at 252.227-7013.          *}
{*                                                                       *}
{*                    TEXAS INSTRUMENTS INCORPORATED.                    *}
{*                            P.O. BOX 149149                            *}
{*                         AUSTIN, TEXAS 78714-9149                      *}
{*                              MS 2151                                  *}
{*                                                                       *}
{*  Copyright (C) 1987,1988,1989,1990 Texas Instruments Incorporated.    *}
{*  All rights reserved.                                                 *}
{*                                                                       *}

{ File DiskCmds.p  - code to simulate Nupi commands.}

UNIT DiskCmds;

{$SETC UDEBUG := TRUE}

INTERFACE

	USES   	Memtypes, QuickDraw, OSIntf, ToolIntf, PackIntf, 
			Nupi, Makepfiles, CommIntf, Primitives, startupintf;
	
	CONST
		{Parameter Displacements}
		
		{* Partition Descriptor *}
		PD_PhysicalUnit = 0;				
		PD_PartitionType = 1;
		PD_NumPartEnts = 2;
		PD_PartEntries = 8;
		PD_PartEntry = 0;
		PD_VolumeName = 2;
		
		{* Volume Info *}
		GVI_PhysicalUnit = 0;			{* 16b = Byte 0. *}	
        GVI_VolumeIndex = 1;            {* 16b = Byte 2. *}	
        GVI_AccessVolume = 1;           {* 16b = Byte 2. *}	
		GVI_Blocks_Allocated = 2;		{* 16b = Byte 4. *}
		GVI_Blocks_Free = 3;			{* 16b = Byte 6. *}
		GVI_Block_Size = 3;				{* 32b = Byte 12.*}
        GVI_VolumeName = 16;            {*  8b = Byte 16.*}

        {* Modify Partition *}
        MP_PhysicalUnit = 0;            {* 16b = Byte 0.  *}
        MP_PartitionType = 1;           {* 16b = Byte 2.  *}
        MP_PartStart = 1;               {* 32b = Byte 4.  *}
        MP_PartLength = 2;              {* 32b = Byte 8.  *}
        MP_VolumeName = 16;             {*  8b = Byte 16. for max of 28. *}
        MP_PartName = 44;               {*  8b = Byte 44. for max of 5. *}
        MP_FileName = 52;               {*  8b = byte 52. for max of 32. *}
        MP_WholeFileName = 84;          {*  8b = Byte 84. for max of 256. *}
        MP_NewPartName = 344;           {*  8b = Byte 344. for max of 5. *}
        MP_NewFileName = 352;           {*  8b = Byte 352. for max of 32. *}
        MP_NewPartType = 194;           {* 16b = Byte 348. *}
        MP_Flags = 195;                 {* 16b = Byte 350. *}
        MP_NewWholeFileName = 400;      {*  8b = Byte 400. *}

        VolNameMaxCount = 28;			{* 27 characters + length byte *}
				
	PROCEDURE DiskCommand(CmdBlkPtr: Ptr);
	
	
IMPLEMENTATION


FUNCTION BuildPartEntry(VolumeIndex, PartFileMapIndex: Integer; CmdBlkPtr: Ptr;
							 var ParmIndex: Integer; ParmSpace: Integer): Integer;
							 
	CONST
		EC_OutOfParmSpace = 1;			{Error Code}
		PE_EntrySize = 84;
		

	VAR
		Status:			Integer;
		Count:			Integer;
		Attrib:			Integer;
		WordIndex:		Integer;
		LongWordIndex:	Integer;
		PFMPtr:			PFMapPtr;
		TempStr:		STRING[16];
		TempPtr:		Ptr;
	
	BEGIN												{BuildPartEntry}
		Status := 0;
		PFMPtr := VolumeArrayPtr^[VolumeIndex].PartFileMapPtr;
		IF PartFileMapIndex > VolumeArrayPtr^[VolumeIndex].NumPFMapEnts THEN
			PrtWarnMesg('PFM Index too large',PartFileMapIndex);
		IF ParmSpace - ParmIndex < PE_EntrySize THEN
			Status := EC_OutOfParmSpace
		ELSE BEGIN
			PFMPtr := VolumeArrayPtr^[VolumeIndex].PartFileMapPtr;
			WordIndex := BSR(ParmIndex, 1); 
			set_parm_16b(CmdBlkPtr, WordIndex, VolumeArrayPtr^[VolumeIndex].PhysUnit);
			
			ParmIndex := ParmIndex + 2;
			WordIndex := BSR(ParmIndex, 1);
			Attrib := PFMPtr^[PartFileMapIndex].Attributes;
			set_parm_16b(CmdBlkPtr, WordIndex, Attrib);
			
			ParmIndex := ParmIndex + 2;
			LongWordIndex := BSR(ParmIndex, 2);
			set_parm_32b(CmdBlkPtr, LongWordIndex, PFMPtr^[PartFileMapIndex].StartBlock);
			
			ParmIndex := ParmIndex + 4;
			LongWordIndex := BSR(ParmIndex, 2);
			set_parm_32b(CmdBlkPtr, LongWordIndex, PFMPtr^[PartFileMapIndex].Length);
			
			ParmIndex := ParmIndex + 4;
			TempPtr := Ptr(@PFMPtr^[PartFileMapIndex].PartitionName[0]);
			Count := Integer(PFMPtr^[PartFileMapIndex].PartitionName[0]) + 1;
			copy_parms_8b(CmdBlkPtr, TempPtr, ParmIndex, Count, to_acb);	{Partition Name}
			
			ParmIndex := ParmIndex + 5;
			TempStr := '""';
			TempPtr := Ptr(@TempStr);
			Count := Length(TempStr) + 1;
			copy_parms_8b(CmdBlkPtr, TempPtr, ParmIndex, Count, to_acb);	{Partition Comment}
			
			ParmIndex := ParmIndex + 17;
			TempStr := Concat(PFMPtr^[PartFileMapIndex].PartitionName, '.EXPLORER');
			TempPtr := Ptr(@TempStr);
			Count := Length(TempStr) + 1;
			copy_parms_8b(CmdBlkPtr, TempPtr, ParmIndex, Count, to_acb);	{Partition-Name-String}
			
			ParmIndex := ParmIndex + 18;
		END;
		BuildPartEntry := Status;
	END;												{BuildPartEntry}

FUNCTION BuildPartList(VolumeIndex, PartitionType: Integer; CmdBlkPtr: Ptr; var PartCount: Integer;
						var ParmIndex: Integer; ParmSpace: Integer): Integer;

	VAR
		i:				Integer;
		Status:			Integer;
		NumPartitions:	Integer;
		PFMPtr:			PFMapPtr;
		
	
	BEGIN												{BuildPartList}
		PartCount := 0;
		Status := 0;
		NumPartitions := VolumeArrayPtr^[VolumeIndex].NumPFMapEnts;
		PFMPtr := VolumeArrayPtr^[VolumeIndex].PartFileMapPtr;
		FOR i := 1 TO NumPartitions DO BEGIN
			IF (PartitionType = -1) OR (PartitionType = PFMPtr^[i].Attributes) THEN BEGIN
				Status := BuildPartEntry(VolumeIndex, i, CmdBlkPtr, ParmIndex, ParmSpace);
				IF Status <> 0 THEN LEAVE
				ELSE PartCount := PartCount + 1;
			END;								{IF PartitionType}
		END;									{FOR}
		BuildPartList := Status;
	END;												{BuildPartList}

	
FUNCTION CountPartitionEntries(VolumeIndex, PartitionType: Integer): Integer;

	VAR
		i:				Integer;
		NumPartitions:	Integer;
		PFMPtr:			PFMapPtr;
		Count:			Integer;
		
	BEGIN												{CountPartitionEntries}
		NumPartitions := VolumeArrayPtr^[VolumeIndex].NumPFMapEnts;
		IF PartitionType = -1 THEN
			CountPartitionEntries := NumPartitions
		ELSE BEGIN
			PFMPtr := VolumeArrayPtr^[VolumeIndex].PartFileMapPtr;
			Count := 0;
			FOR i := 1 TO NumPartitions DO BEGIN
				IF PFMPtr^[i].Attributes = PartitionType  THEN
					Count := Count + 1;
			END;
			CountPartitionEntries := Count;
		END;									{ELSE}
		END;                                    {CountPartitionEntries}


{* Returns the index for PartitionName, or -1 if not found *}
FUNCTION FindPartition(VolumeIndex, PartitionType, Start: LongInt; PartitionName: PartName): Integer;
    CONST
	    UPCASE = $20;
									
	VAR
		i,j:			Integer;
		NumPartitions:	Integer;
		PFMPtr:			PFMapPtr;
		Match:          Boolean;
	
	BEGIN
		Match := FALSE;
	    FindPartition := -1;
		NumPartitions := VolumeArrayPtr^[VolumeIndex].NumPFMapEnts;
		PFMPtr := VolumeArrayPtr^[VolumeIndex].PartFileMapPtr;
		FOR i := 1 TO NumPartitions DO BEGIN
		    Match := FALSE;
			IF (PartitionType = PFMPtr^[i].Attributes) THEN BEGIN
			    Match := TRUE;
			    FOR j := 1 to 4 DO BEGIN
				    IF BOR(ORD(PFMPtr^[i].PartitionName[j]), UPCASE) <> BOR(ORD(PartitionName[j]), UPCASE) THEN BEGIN
					    Match := FALSE;
						Leave;
						END;
				    END; {For j}
			    END; {IF}
			{* Check for match and either no START specified, or MATCHes the START provided *}
			IF (Match = TRUE) AND ((Start = 0) OR   
                                   (PFMPtr^[i].StartBlock = Start)) THEN BEGIN
			    FindPartition := i;
				Leave;
				END;
		    END;  {For i}
	END;


FUNCTION AddToPFMap (Volume, PartAttrib: Integer; NewPartName: PartName; 
                     FileNamePtr: StringPtr; LengthInBlocks: LongInt): INTEGER;
						
	CONST
		TooManyPartitionFiles = -1;

	VAR
		NumParts, PFNum:        Integer;
		PrevStart:              LongInt;
		
	BEGIN
		NumParts := VolumeArrayPtr^[Volume].NumPFMapEnts;
        PFNum := NumParts + 1;

		IF PFNum > VolumeArrayPtr^[Volume].MaxPFMapEnts THEN BEGIN    {ab 10/26/88.  Check against MAX!!}
		    AddToPFMap := TooManyPartitionFiles;
			END
		ELSE BEGIN
		    WITH VolumeArrayPtr^[Volume].PartFileMapPtr^[PFNum] DO BEGIN
			    IF PFNum = 1 THEN BEGIN
				   StartBlock := StartDiskBlock;
				   END
				ELSE BEGIN  {* 1 million more than the previous start *}
				   PrevStart := VolumeArrayPtr^[Volume].PartFileMapPtr^[PFNum - 1].StartBlock;
				   StartBlock := (ArbitraryPartLength * (1 + (PrevStart DIV ArbitraryPartLength)))
									+ StartDiskBlock;
				   END;
				Length := LengthInBlocks;
				FileRefNum := 0;
				PartitionName := NewPartName;
				FileName := FileNamePtr^;
				Attributes := PartAttrib;
				FileOpen := FALSE;
				END; {WITH}

			{* Finally, update number of PFiles on this volume *}
			VolumeArrayPtr^[Volume].NumPFMapEnts := PFNum;
            AddToPFMap := 0;
			END; {ELSE}
	END;

	
FUNCTION DeleteFromPFMap (Volume, PartAttrib: Integer; Start: Longint; DPartName: PartName): INTEGER;
						
	CONST
	    PartitionNotFound = 1;
		BadEntryNumber = 2;

	VAR
        i, EntryNumber:         Integer;
		NumParts,Status:        Integer;
        RefNum, VRefNum:        Integer;
        FileOpen:               Boolean;   
		PB:                     ParamBlockRec; 
		
	BEGIN
	    Status := 0;
		NumParts := VolumeArrayPtr^[Volume].NumPFMapEnts;
        EntryNumber := FindPartition(Volume, PartAttrib, Start, DPartName);

		IF EntryNumber < 0 THEN BEGIN
		    DeleteFromPFMap := PartitionNotFound;
			END
		ELSE IF EntryNumber > NumParts THEN BEGIN
		    DeleteFromPFMap := BadEntryNumber;
			END
		ELSE BEGIN
            {* If this file is open, close it & Flush Volume *}
            FileOpen := VolumeArrayPtr^[Volume].PartFileMapPtr^[EntryNumber].FileOpen;
            Refnum := VolumeArrayPtr^[Volume].PartFileMapPtr^[EntryNumber].FileRefNum;
			IF FileOpen THEN BEGIN
			    PB.ioCompletion := NIL;
				PB.ioRefNum := Refnum;
                Status := PBClose(@PB, FALSE);
				IF Status = 0 THEN BEGIN
					VRefNum := VolumeArrayPtr^[Volume].VolRefNum;
					PB.ioNamePtr := NIL;
					PB.ioVRefNum := VrefNum;
					Status := PBFlushVol(@PB, FALSE);
					END; {IF Status}
                END; {IF FileOpen}

            {* Move subsequent PFEntries down *}
		    FOR i := EntryNumber TO NumParts - 1 DO
                VolumeArrayPtr^[Volume].PartFileMapPtr^[i] :=
                    VolumeArrayPtr^[Volume].PartFileMapPtr^[i+1];
            
			{* Finally, update number of PFiles on this volume *}
		    VolumeArrayPtr^[Volume].NumPFMapEnts := NumParts - 1;
            DeleteFromPFMap := Status;    {* Non-zero now if CLOSE or FLUSH-VOL got error *}
			END; {ELSE}
	END;


FUNCTION ModifyPFMap (Volume, PartAttrib, NewAttrib: Integer; Start, NewLength: Longint;  
                      DPartName, NewPartName: PartName;  NewFileNamePtr: StringPtr): Integer;
	CONST
	    PartitionNotFound = 1;
		BadEntryNumber = 2;

	VAR
        EntryNumber:            Integer;
		NumParts,Status:        Integer;
        RefNum, VRefNum:        Integer;
        FileOpen:               Boolean;
        PB:                     ParamBlockRec;
		
	BEGIN
	    Status := 0;
		NumParts := VolumeArrayPtr^[Volume].NumPFMapEnts;
        EntryNumber := FindPartition(Volume, PartAttrib, Start, DPartName);

		IF EntryNumber < 0 THEN BEGIN
		    ModifyPFMap := PartitionNotFound;
			END
		ELSE IF EntryNumber > NumParts THEN BEGIN
		    ModifyPFMap := BadEntryNumber;
			END
        ELSE BEGIN
		    WITH VolumeArrayPtr^[Volume].PartFileMapPtr^[EntryNumber] DO BEGIN
				IF NewLength <> 0 THEN Length := NewLength;   {* 0 NewLength is flag saying change is for name/attrib only *}
				PartitionName := NewPartName;
				FileName := NewFileNamePtr^;
				Attributes := NewAttrib;
				{* Start, FileRefnum, and FileOpen stay same *}
				END; {WITH}
		    END; {ELSE}
    END;


PROCEDURE DisplayVol(VolumeIndex: integer);

	VAR
		i,j:		Integer;
		PFMPtr:		PFMapPtr;
	
	BEGIN
		i := VolumeIndex;
		Writeln('Vol Index = ',i);
		Writeln(' VolRef# = ',VolumeArrayPtr^[i].VolRefNum);
		Writeln(' PhysUnit = ',VolumeArrayPtr^[i].PhysUnit);
        Writeln(' VolName = ', VolumeArrayPtr^[i].VolName);
		Writeln(' Max PFMEnts =',VolumeArrayPtr^[i].MaxPFMapEnts);   {ab 10/26/88}
		Writeln(' #PFMEnts =',VolumeArrayPtr^[i].NumPFMapEnts);
		FOR j := 1 TO VolumeArrayPtr^[i].NumPFMapEnts DO BEGIN
			PFMPtr := VolumeArrayPtr^[i].PartFileMapPtr;
			IF PFMPtr <> NIL THEN BEGIN
				Writeln(' PFM Entry #',j);
				Writeln('  Start = ',PFMPtr^[j].StartBlock);
				Writeln('  Length = ',PFMPtr^[j].Length);
				Writeln('  Attrib = ',PFMPtr^[j].Attributes);
				Writeln('  FileName = [ ',PFMPtr^[j].FileName,' ]');
				Writeln('  PartName = [ ',PFMPtr^[j].PartitionName,' ]');
				Writeln('  FileOpen = ',PFMPtr^[j].FileOpen);					
				END;
			END;
	END;


PROCEDURE DisplayVols;

	VAR
		i:		Integer;
	
	BEGIN
		FOR i := 1 TO NumVolumes DO BEGIN
			DisplayVol(i);
			END;
	END;
	

PROCEDURE DiskCommand(CmdBlkPtr: Ptr);

	CONST
		NormalCompletion = 0;
		BadVolumeNumber = 10;
		
	VAR
	    Flags:              Integer;
		SubOp:				Integer;
		Count:		        Integer;
		TotalCount:			Integer;    
		PhysUnit:			Integer;
		PartType:			Integer;
		NewType:			Integer;
		ParmIndex:			Integer;  
		ParmSpace:			LongInt;
		NumParms:			LongInt;
		Volume:				Integer;
		Start:				Integer;
		Last:				Integer;
		AccessVol:          Integer;
		VolNamePtr:			Ptr;
		Status:				Integer;
		SHostName, SDefaultDevice, s1, s2:	str255;
        sptr:               StringPtr;
		TempL, Length:		longint;
        StartBlock:         Longint;
		Result:             Integer;
		startup_tbl_ptr:	Ptr;
		PartitionName,
          NewPartName:      PartName;
		FileName, 
          NewFileName:      STRING[32];
		HPB:				HParamBlockRec;
        PB:                 ParamBlockRec;

	BEGIN
	{It is assumed that this procedure is called in 24 bit mode}
	
		SubOp := SubOpcode(CmdBlkPtr);
		ParmSpace := data_bytes(CmdBlkPtr);
		NumParms := parm_bytes(CmdBlkPtr);
		
		REPEAT					{Dummy REPEAT so LEAVE can be used}
			
		CASE SubOp of				{Disk command}
		
			  1:BEGIN					{Get Partition List}		
			  		PhysUnit := parm_16b(CmdBlkPtr, PD_PhysicalUnit);
					PartType := parm_16b(CmdBlkPtr, PD_PartitionType);
					ParmIndex := PD_PartEntries;		
					IF PhysUnit = -1 THEN BEGIN
						Start := 1;
						Last := NumVolumes;
					END
					ELSE BEGIN
						Start := GetVolumeIndex(PhysUnit);
						Last := Start;
					END;
					TotalCount := 0;
					FOR Volume := Start TO Last DO BEGIN
						Status := BuildPartList(Volume, PartType, CmdBlkPtr, Count, 
													ParmIndex, Parmspace);
						TotalCount := TotalCount + Count;
						set_parm_16b(CmdBlkPtr, PD_NumPartEnts, TotalCount);
						IF Status <> 0 THEN BEGIN
							PrtWarnMesg('Error on GPL = ',status);
							set_error_code(CmdBlkPtr, Status);
							LEAVE; 
						END;
					END;
				END;					{Get Partition List}
						
			  2:BEGIN						{Get Number of Partition List Entries}
					PhysUnit := parm_16b(CmdBlkPtr, PD_PhysicalUnit);
					PartType := parm_16b(CmdBlkPtr, PD_PartitionType);
					IF PhysUnit = -1 THEN BEGIN
						Start := 1;
						Last := NumVolumes;
					END
					ELSE BEGIN
						Start := GetVolumeIndex(PhysUnit);
						Last := Start;
					END;
					TotalCount := 0;
					FOR Volume := Start TO Last DO BEGIN
						Count := CountPartitionEntries(Volume, PartType);
						TotalCount := TotalCount + Count;
					END;
					set_parm_16b(CmdBlkPtr, PD_NumPartEnts, TotalCount);
				END;						{Get Number of Partition List Entries}
					
				
			  3:BEGIN				{Get Volume Name}
					PhysUnit := parm_16b(CmdBlkPtr, PD_PhysicalUnit);
					Volume := GetVolumeIndex(PhysUnit);
					IF Volume > NumVolumes THEN BEGIN
                        Writeln('Bad Volume number: phys=', PhysUnit, ' Vol=', Volume);
						set_error_code(CmdBlkPtr, BadVolumeNumber);
						Leave;
                        END;

					{* Get info from static MAP *}
					Count := Integer(VolumeArrayPtr^[Volume].VolName[0]) + 1;
					VolNamePtr := Ptr(@VolumeArrayPtr^[Volume].VolName[0]);
					copy_parms_8b(CmdBlkPtr, VolNamePtr, PD_VolumeName, Count, to_acb);
				END;				{Get Volume Name}
				
			  4:BEGIN			{Get Booted Load Band Info}
					ParmIndex := PD_PartEntry;
					Status := BuildPartEntry(BootedLoad_VolumeIndex, BootedLoad_PartIndex, CmdBlkPtr, 
												ParmIndex, ParmSpace);
					IF Status <> 0 THEN BEGIN
						PrtWarnMesg('Error on GBLBI = ',status);
						set_error_code(CmdBlkPtr, Status);
					END;
				END;			{Get Booted Load Band Info}
				
			  5:BEGIN			{Get Booted MCR Band Info}
					ParmIndex := PD_PartEntry;
					Status := BuildPartEntry(BootedMCR_VolumeIndex, BootedMCR_PartIndex, CmdBlkPtr, 
												ParmIndex, ParmSpace);
					IF Status <> 0 THEN
						set_error_code(CmdBlkPtr, Status);
				END;			{Get Booted MCR Band Info}
							
			  6:BEGIN			{Get Default Device Info}
					startup_tbl_ptr := read_startup;
					TempL := longint(startup_tbl_ptr);
					count := 0;
					if (TempL <> 0) THEN BEGIN
						s1 := startup_defaultdevice(startup_tbl_ptr);	
						SDefaultDevice := c2pcopy(s1);
						Count := Integer(SDefaultDevice[0]) + 1;
						VolNamePtr := Ptr(@SDefaultDevice[0]);
						END;
					if (count = 1) THEN BEGIN	{None specified in startup so default to unit 0}
						{$IFC limpet} 	
							writeln('Could not find defaultdevice in Startup file. Using unit 0.');
						{$ENDC}		
						Volume := GetVolumeIndex(0);
						Count := Integer(VolumeArrayPtr^[Volume].VolName[0]) + 1;
						VolNamePtr := Ptr(@VolumeArrayPtr^[Volume].VolName[0]);
						END;
					copy_parms_8b(CmdBlkPtr, VolNamePtr, PD_VolumeName, Count, to_acb);
				END;			{Get Default Device Info}
							
			  7:BEGIN			{Get Host Name Info}
					startup_tbl_ptr := read_startup;
					TempL := longint(startup_tbl_ptr);
					count := 0;
					if (TempL <> 0) THEN BEGIN
						s1 := startup_HostName(startup_tbl_ptr);	
						SHostName := c2pcopy(s1);
						Count := Integer(SHostName[0]) + 1;
						VolNamePtr := Ptr(@SHostName[0]);
						END;
					if (count = 1) THEN BEGIN	{None specified in startup so default to unit 0}	
						Volume := GetVolumeIndex(0);
						Count := Integer(VolumeArrayPtr^[Volume].VolName[0]) + 1;
						VolNamePtr := Ptr(@VolumeArrayPtr^[Volume].VolName[0]);
						{$IFC limpet} 	
							writeln('Could not find hostname in Startup file. Using unit 0.');
						{$ENDC}		
						END;
					copy_parms_8b(CmdBlkPtr, VolNamePtr, PD_VolumeName, Count, to_acb);
				END;			{Get Host Name Info}
			  8:BEGIN			{Display PFMap Info (debug)}
					PhysUnit := parm_16b(CmdBlkPtr, GVI_PhysicalUnit);
					Volume := GetVolumeIndex(PhysUnit);
                    DisplayVol(Volume);
				END;
			  9:BEGIN           {Get Vol Space Info}
					PhysUnit := parm_16b(CmdBlkPtr, GVI_PhysicalUnit);
					Volume := GetVolumeIndex(PhysUnit);
					IF Volume > NumVolumes THEN BEGIN
                        Writeln('Bad Volume number: phys=', PhysUnit, ' Vol=', Volume);
						set_error_code(CmdBlkPtr, -1);
                        END
                    ELSE BEGIN
						HPB.ioCompletion := NIL;
						HPB.ioNamePtr := NIL;
						HPB.ioVRefNum := VolumeArrayPtr^[Volume].VolRefNum;
						HPB.ioVolInDex := 0;	{* use Refnum only to find volume *}
						Status := PBHGetVInfo(@HPB, FALSE);
						IF Status <> 0 THEN BEGIN
							set_error_code(CmdBlkPtr, -1);
							END
						ELSE BEGIN
							set_parm_16b(CmdBlkPtr, GVI_Blocks_Allocated, HPB.ioVNmAlBlks);
							set_parm_16b(CmdBlkPtr, GVI_Blocks_Free, HPB.ioVFrBlk);
							set_parm_32b(CmdBlkPtr, GVI_Block_Size, HPB.ioVAlBlkSiz);
                        END;
					END;
			    END;
             10:BEGIN           {Add Partition}
			        {* Get parms from CMD block *}
					PhysUnit := parm_16b(CmdBlkPtr, MP_PhysicalUnit);
					Volume := GetVolumeIndex(PhysUnit);
 					PartType := parm_16b(CmdBlkPtr, MP_PartitionType);
 					Length := parm_32b(CmdBlkPtr, MP_PartLength);
					
					Count := 1 + parm_8b(CmdBlkPtr, MP_PartName);
					copy_parms_8b(CmdBlkPtr, @PartitionName, MP_PartName, Count, to_array);
					Count := 1 + parm_8b(CmdBlkPtr, MP_FileName);
					copy_parms_8b(CmdBlkPtr, @FileName, MP_FileName, Count, to_array);
					Count := 1 + parm_8b(CmdBlkPtr, MP_WholeFileName);
					copy_parms_8b(CmdBlkPtr, @s1, MP_WholeFileName, Count, to_array);
					{*  Writeln ('Vol index= ', Volume, '  Len= ', length, '  PartName= ', PartitionName);
					    Writeln ('FileName=', FileName, '  Whole filename= ', s1);  *}

					{* Make the file *}
                    Result := MakePFile(s1, Length);
					IF Result < 0 THEN BEGIN
					    set_error_code(CmdBlkPtr, Result);
						Leave;
						END;
                    Status := AddToPFMap(Volume, PartType, PartitionName, @FileName, Length);
					set_error_code(CmdBlkPtr, Status);
                END;
             11:BEGIN           {Modify Partition}
			        {* Get parms from CMD block *}
					PhysUnit := parm_16b(CmdBlkPtr, MP_PhysicalUnit);
					Volume := GetVolumeIndex(PhysUnit);
 					PartType := parm_16b(CmdBlkPtr, MP_PartitionType);
                    NewType := parm_16b(CmdBlkPtr, MP_NewPartType);
 					Length := parm_32b(CmdBlkPtr, MP_PartLength);
					StartBlock := parm_32b(CmdBlkPtr, MP_PartStart);
					Flags := parm_16b(CmdBlkPtr, MP_Flags);
					
					Count := 1 + parm_8b(CmdBlkPtr, MP_PartName);
					copy_parms_8b(CmdBlkPtr, @PartitionName, MP_PartName, Count, to_array);
					Count := 1 + parm_8b(CmdBlkPtr, MP_FileName);
					copy_parms_8b(CmdBlkPtr, @FileName, MP_FileName, Count, to_array);
					Count := 1 + parm_8b(CmdBlkPtr, MP_NewPartName);
					copy_parms_8b(CmdBlkPtr, @NewPartName, MP_NewPartName, Count, to_array);
					Count := 1 + parm_8b(CmdBlkPtr, MP_NewFileName);
					copy_parms_8b(CmdBlkPtr, @NewFileName, MP_NewFileName, Count, to_array);
					Count := 1 + parm_8b(CmdBlkPtr, MP_WholeFileName);
					copy_parms_8b(CmdBlkPtr, @s1, MP_WholeFileName, Count, to_array);
					Count := 1 + parm_8b(CmdBlkPtr, MP_NewWholeFileName);
					copy_parms_8b(CmdBlkPtr, @s2, MP_NewWholeFileName, Count, to_array);
					{* Writeln ('Vol index= ', Volume, '  Len= ', length, ' Start= ', StartBlock,
								 ' PartName= ', PartitionName);
					  Writeln ('FileName=', FileName, '  Whole filename= ', s1);
                      Writeln ('New Partname=', NewPartname, ' New Filename=', NewFileName);
					  Writeln ('New Whole Filename=', s2, '  Flags= ', Flags);
					  Writeln ('TYPE=', PartType, ' New Type=', NewType); *}  

					IF Length <> 0  THEN BEGIN       {* 0-length means changes are to name, type only *}
					   {* Make the file *}
					   Result := MakePFile(s1, Length);
					   IF Result < 0 THEN BEGIN
						  set_error_code(CmdBlkPtr, Result);
						  Leave;
						  END;
					   END;
                    Status := ModifyPFMap (Volume, PartType, NewType, StartBlock, Length,
										   PartitionName, NewPartName, @NewFileName);
					set_error_code(CmdBlkPtr, Status);
					IF Status <> 0 THEN Leave;

					{* Rename the file if necessary (flags will be non-zero) *}
					IF Flags <> 0 THEN BEGIN
					   PB.ioCompletion := NIL;
					   PB.ioNamePtr := @s1;
					   PB.ioVRefNum := 0;
					   PB.ioVersNum := 0;
					   PB.ioMisc := @s2;
					   Status := PBRename(@PB, FALSE);
					   set_error_code(CmdBlkPtr, Status);
					   END;
                END;
             12:BEGIN           {Delete Partition}
			        {* Get parms from CMD block *}
					PhysUnit := parm_16b(CmdBlkPtr, MP_PhysicalUnit);
					Volume := GetVolumeIndex(PhysUnit);
 					PartType := parm_16b(CmdBlkPtr, MP_PartitionType);
					StartBlock := parm_32b(CmdBlkPtr, MP_PartStart);
					
					Count := 1 + parm_8b(CmdBlkPtr, MP_PartName);
					copy_parms_8b(CmdBlkPtr, @PartitionName, MP_PartName, Count, to_array);
					Count := 1 + parm_8b(CmdBlkPtr, MP_FileName);
					copy_parms_8b(CmdBlkPtr, @FileName, MP_FileName, Count, to_array);
					Count := 1 + parm_8b(CmdBlkPtr, MP_WholeFileName);
					copy_parms_8b(CmdBlkPtr, @s1, MP_WholeFileName, Count, to_array);
					{* Writeln ('Vol index= ', Volume,  ' Start= ', StartBlock, 'Type=', PartType);
					   Writeln (' PartName= ', PartitionName, ' FileName=', FileName);
					   Writeln (' WholeName= ', s1); *}

					status := DeleteFromPFMap (Volume, PartType, StartBlock, PartitionName);
					IF Status <> 0 THEN BEGIN
					   set_error_code(CmdBlkPtr, Status);
					   Leave;
					   END;

					{* Delete the file *}
					PB.ioCompletion := NIL;
					PB.ioNamePtr := @s1;
					PB.ioVRefNum := 0;
					PB.ioVersNum := 0;
					Status := PBDelete(@PB, FALSE);
					set_error_code(CmdBlkPtr, Status);
                END;
			{* Unused range 13-17 *}
             18:BEGIN           {Flush Volume}
					sptr := @s1;
					Count := 1 + parm_8b(CmdBlkPtr, MP_VolumeName);
					copy_parms_8b(CmdBlkPtr, Ptr(sptr), MP_VolumeName, Count, to_array);

					PB.ioCompletion := NIL;
                    PB.ioNamePtr := sptr;      {* Use the Volume string to identify Vol *}
					PB.ioVRefNum := 0;
					Status := PBFlushVol(@PB, FALSE);
					set_error_code(CmdBlkPtr, Status);
                END;
             19:BEGIN           {Flush File}
					sptr := @s1;
					Count := 1 + parm_8b(CmdBlkPtr, MP_WholeFileName);
					copy_parms_8b(CmdBlkPtr, Ptr(sptr), MP_WholeFileName, Count, to_array);
                    {* Writeln('Whole File Name = ', s1); *}

					{* Call OPEN to get RefNum *}
					PB.ioCompletion := NIL;
                    PB.ioNamePtr := sptr;      {* Use the full name string to identify file *}
					PB.ioVRefNum := 0;
					PB.ioVersNum := 0;
					PB.ioPermssn :=  fsRdPerm;
					PB.ioMisc := NIL;
                    Status := PBOpen(@PB, FALSE);

					IF Status <> 0 THEN BEGIN
                        {* Writeln('PBOpen Error = ', Status); *}
					    set_error_code(CmdBlkPtr, Status);
						END
					ELSE BEGIN
					    {* Refnum is in PB from OPEN call *}
					    Status := PBFlushFile(@PB, FALSE);
					    set_error_code(CmdBlkPtr, Status);        {* Return FlushFile call's status *}

						{* Now close the file *}
						Status := PBClose(@PB, FALSE);
						If Status <> 0 THEN Writeln('PBClose Error = ', Status);
						END;
                END;
             20:BEGIN      {New get volume name}
					PhysUnit := parm_16b(CmdBlkPtr, GVI_PhysicalUnit);
					AccessVol := parm_16b(CmdBlkPtr, GVI_AccessVolume);
					Volume := GetVolumeIndex(PhysUnit);
					IF Volume > NumVolumes THEN BEGIN
                        Writeln('Bad Volume number: phys=', PhysUnit, ' Vol=', Volume);
						set_error_code(CmdBlkPtr, BadVolumeNumber);
						Leave;
                        END;
					IF AccessVol <> 0 THEN BEGIN
					    {* User says OK to access volume physically *}
					    HPB.ioCompletion := NIL;
						HPB.ioNamePtr := @s1;   {* Non-0 means return namestring pointer *}
						HPB.ioVRefNum := VolumeArrayPtr^[Volume].VolRefNum;
						HPB.ioVolIndex := 0;	{* use ref num to access volume *}
						Status := PBHGetVInfo(@HPB, FALSE);
						IF Status <> 0 THEN BEGIN
						    set_error_code(CmdBlkPtr, Status);       {* Return Status Code *}
							Leave;
						    END;
					        
						{* Update the map *}
						VolumeArrayPtr^[Volume].VolName := HPB.ioNamePtr^;
						END; {IF AccessVol}

					{* Now just get info from static MAP *}
					Count := Integer(VolumeArrayPtr^[Volume].VolName[0]) + 1;
					VolNamePtr := Ptr(@VolumeArrayPtr^[Volume].VolName[0]);
					copy_parms_8b(CmdBlkPtr, VolNamePtr, GVI_VolumeName, Count, to_acb);
			    END;
			OTHERWISE
					PrtWarnMesg('Bad Disk Cmd SubOpcode',SubOp);					


		END; {of Case}
			
	UNTIL TRUE;   {* End of Dummy REPEAT *}
	
	END; {of DiskCommand}
	

END.
